# MLtool

---

Shreyas Honrao¹², Nishan Senanayake³⁴, Stephen R. Xie¹², Bethany Wu¹⁴, Joshua Stuckner³, Nikolai A. Zarkevich¹

__This package is designed to provide machine learning tools for fitting numeric, tabular data.__

* Regression and classification
* Explanatory Data Analysis
* Preprocessing
* Cross-validation
* Hybrid models
* Uncertainty Quantification
* Automatic Ranking

Contact: nikolai.a.zarkevich@nasa.gov

¹ NASA Ames Research Center

² KBR Wyle Services

³ NASA Glenn Research Center

⁴ Universities Space Research Association (usra.edu)

---

## Installation

```
git clone <...>/mltool/mltool.git
cd mltool

pip install -r requirements.txt
```

MLtool has been tested with Python 3.8 through Python 3.11. ```requirements_py311.txt``` contains pinned package specifications for a Python 3.11 installation.

## Usage
* Place `.csv` file in `data/`
* Prepare configuration file: `parameters.yaml`
* Run MLtool
```python main.py```
* Analyze results generated in `output/`

## Configuration (`parameters.yaml`)
Please refer to the technical report for details and valid value ranges for each parameter in the user input file.

## Dependencies
| Package | Usage |
|---------|-------|
| scikit-learn | Machine Learning |
| pandas | I/O and processing of Tabular data |
| ydata-profiling | Exploratory Data Analysis |
| MAPIE | Uncertainty Quantification|
| xgboost | Gradient Boosted Machines |
| matplotlib | Plotting, Figures |
| tqdm | Progress bars |

## Disclaimers
Please see NASA OPEN SOURCE AGREEMENT VERSION 1.3 for more details.

No Warranty: THE SUBJECT SOFTWARE IS PROVIDED AS IS WITHOUT ANY WARRANTY OF ANY KIND, EITHER EXPRESSED, IMPLIED, OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, ANY WARRANTY THAT THE SUBJECT SOFTWARE WILL CONFORM TO SPECIFICATIONS, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR FREEDOM FROM INFRINGEMENT, ANY WARRANTY THAT THE SUBJECT SOFTWARE WILL BE ERROR FREE, OR ANY WARRANTY THAT DOCUMENTATION, IF PROVIDED, WILL CONFORM TO THE SUBJECT SOFTWARE. THIS AGREEMENT DOES NOT, IN ANY MANNER, CONSTITUTE AN ENDORSEMENT BY GOVERNMENT AGENCY OR ANY PRIOR RECIPIENT OF ANY RESULTS, RESULTING DESIGNS, HARDWARE, SOFTWARE PRODUCTS OR ANY OTHER APPLICATIONS RESULTING FROM USE OF THE SUBJECT SOFTWARE. FURTHER, GOVERNMENT AGENCY DISCLAIMS ALL WARRANTIES AND LIABILITIES REGARDING THIRD-PARTY SOFTWARE, IF PRESENT IN THE ORIGINAL SOFTWARE, AND DISTRIBUTES IT AS IS.

Waiver and Indemnity: RECIPIENT AGREES TO WAIVE ANY AND ALL CLAIMS AGAINST THE UNITED STATES GOVERNMENT, ITS CONTRACTORS AND SUBCONTRACTORS, AS WELL AS ANY PRIOR RECIPIENT. IF RECIPIENT'S USE OF THE SUBJECT SOFTWARE RESULTS IN ANY LIABILITIES, DEMANDS, DAMAGES, EXPENSES OR LOSSES ARISING FROM SUCH USE, INCLUDING ANY DAMAGES FROM PRODUCTS BASED ON, OR RESULTING FROM, RECIPIENT'S USE OF THE SUBJECT SOFTWARE, RECIPIENT SHALL INDEMNIFY AND HOLD HARMLESS THE UNITED STATES GOVERNMENT, ITS CONTRACTORS AND SUBCONTRACTORS, AS WELL AS ANY PRIOR RECIPIENT, TO THE EXTENT PERMITTED BY LAW. RECIPIENT'S SOLE REMEDY FOR ANY SUCH MATTER SHALL BE THE IMMEDIATE, UNILATERAL TERMINATION OF THIS AGREEMENT.
