import warnings

import pandas as pd
from tqdm import tqdm
import time
from sklearn.pipeline import Pipeline
from validation import run_validation_kfold, run_validation_leave_p_out, run_validation_standard, \
    run_validation_user_defined
from inputdata import InputData

warnings.filterwarnings("ignore")


class MlTool:
    """
    MLTool
    """
    models = {}

    def fit(self, input_data: InputData):
        """
        Loops through all the the selected regressors train and test the model
        :param input_data:
        :return:
            scores: a pandas dataframe containing scores for all selected scoring metrics ,
            predictions_df: predicted Y values for test data
            predictions_all: predicted Y values for all data,
            self.models: all trained modles
        """

        predictions_all = {}
        predictions = {}

        scores = {
            "Model": [],
            "Time Taken": []
        }

        for name, model in tqdm(input_data.regress):
            start = time.time()
            try:
                params = input_data.get_parameters(name, model().get_params().keys())
                model.verbose = False
                pipe = Pipeline(steps=[
                    ("preprocessor", input_data.get_preprocessor()),
                    ("regressor", model(**params))])

                pipe.verbose = False
                self.models[name] = pipe.fit(input_data.X_train, input_data.y_train)

                y_pred = pipe.predict(input_data.X_test)
                y_pred_all = pipe.predict(input_data.X)

                val_method = next(iter(input_data.user_param['validation']))
                scores = eval('run_validation_' + val_method + '(pipe, input_data, scores, y_pred)')

                scores["Model"].append(name)
                scores["Time Taken"].append(time.time() - start)
                predictions[name] = y_pred
                predictions_all[name] = y_pred_all
            except Exception as exception:
                pass

        scores = pd.DataFrame(scores)
        scores = scores.sort_values(scores.columns[5], ascending=True).set_index("Model")

        predictions_df = pd.DataFrame.from_dict(predictions)
        predictions_all = pd.DataFrame.from_dict(predictions_all)
        return scores, predictions_df, predictions_all, self.models
