
from sklearn.linear_model import LinearRegression
from sklearn.preprocessing import PolynomialFeatures


class Polynomial(LinearRegression):
    """
    Polynomial regression class created by extending ordinary least squares Linear Regression.
    """
    def __init__(
            self,
            *,
            fit_intercept=True,
            normalize="deprecated",
            copy_X=True,
            n_jobs=None,
            positive=False,
            degree=None
    ):
        self.fit_intercept = fit_intercept
        self.normalize = normalize
        self.copy_X = copy_X
        self.n_jobs = n_jobs
        self.positive = positive
        self.degree = degree

    def fit(self, X, y, sample_weight=None):
        """
        Fit polynomial model.
         Parameters
        ----------
        X : {array-like, sparse matrix} of shape (n_samples, n_features)
            Training data.

        y : array-like of shape (n_samples,) or (n_samples, n_targets)
            Target values. Will be cast to X's dtype if necessary.

        sample_weight : array-like of shape (n_samples,), default=None
            Individual weights for each sample.

            .. versionadded:: 0.17
               parameter *sample_weight* support to LinearRegression.

        Returns
        -------
        self : object
            Fitted Estimator.
        """
        poly_features = PolynomialFeatures(degree=self.degree)
        x_poly = poly_features.fit_transform(X)
        return super().fit(x_poly, y, sample_weight=sample_weight)

    def predict(self, X):
        """
        Predict using the polynomial model.

        Parameters
        ----------
        X : array-like or sparse matrix, shape (n_samples, n_features)
            Samples.

        Returns
        -------
        C : array, shape (n_samples,)
            Returns predicted values.
        """
        poly_features = PolynomialFeatures(degree=self.degree)
        x_poly = poly_features.fit_transform(X)
        return super().predict(x_poly)



